import React from 'react';
import { block } from 'bem-cn';

import { i18n } from 'i18n2';
import NavLink from 'components2/NavLink';
import { ServiceIcon } from 'components/Icon';
import metrika from 'api2/metrika';

import './index.css';

const b = block('service-resource');

const ServiceResource = ({ serviceSlug, name, id, description, url, hard, target, actionText, children }) => {
    function sendMetrika() {
        metrika.send(
            'Сервис с ресурсами',
            serviceSlug,
            'Клик по ресурсу в списке',
        );
    }

    return (
        <div className={b()}>
            <div className={b('card')}>
                <NavLink
                    hard={hard}
                    url={url}
                    target={target}
                    theme="normal"
                    cls={b('link')}
                    onClick={sendMetrika}
                >
                    <div className={b('header')}>
                        <ServiceIcon
                            cls={b('icon')}
                            serviceSlug={serviceSlug}
                        />
                        {id && <div className={b('id')}>{id}</div>}
                    </div>
                    {name && <div className={b('name')}>{name}</div>}
                    {children}
                    {description && <div className={b('description')}>{description}</div>}
                    <div className={b('link-text')}>
                        {actionText || i18n(`service_page.${serviceSlug}.manage_resource`) ||
                        i18n('service_page.default.manage_resource')}
                    </div>
                </NavLink>
            </div>
        </div>
    );
};

export default ServiceResource;
