import React from 'react';
import block from 'bem-cn';
import getService from 'lib2/getService';
import { i18n } from 'i18n2';

import './index.css';

const b = block('service-status');

export default ({ serviceSlug }) => {
    let { enabled, ready } = getService(serviceSlug);
    let key;

    if (enabled) {
        key = ready ? 'enabled' : 'enabling';
    } else {
        key = 'disabled';
    }

    let status = i18n(`service_page.${serviceSlug}.${key}`) ||
        i18n(`service_page.default.${key}`);

    return <span className={b({ [key]: true })}>{status}</span>;
};
