import React from 'react';
import Modal from 'components2/Modal';
import getText from './getText';

export default ({ serviceSlug, onConfirm, onCancel, visible }) => (
    <Modal visible={visible}>
        <Modal.Title>
            {getText('disable.title', serviceSlug)}
        </Modal.Title>
        <Modal.CloseButton onClick={onCancel} />
        <Modal.Body type="warning">
            {getText('disable.no_trial', serviceSlug)}
        </Modal.Body>
        <Modal.ConfirmActions
            onConfirm={onConfirm}
            onCancel={onCancel}
            confirmCaption={getText('action.disable', serviceSlug)}
        />
    </Modal>
);
