// lego Spin + overlay

// закрывает весь родительский элемент прозрачным блоком, когда props.progress: true;
// по истечении props.spinDelay (default: 0ms) показывает спиннер на полупрозрачном фоне;

// spinDelay позволяет показывать спиннер только при относительно долгих операциях,
// не внося визуальных изменений при быстрых операциях,
// но сразу блокируя контент от пользовательских действий

import React from 'react';
import { Spin } from 'lego-on-react';
import { block } from 'bem-cn';

import './index.css';

const b = block('spin-overlay');

export default class extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            spinVisible: props.spinVisible,
        };
    }

    componentDidMount() {
        this._update();
    }

    componentDidUpdate(prevProps) {
        if (prevProps.progress !== this.props.progress) {
            this._update();
        }
    }

    componentWillUnmount() {
        this._unmounted = true;
    }

    _update() {
        let { progress, spinDelay = 0, spinVisible } = this.props;

        if (spinVisible !== undefined) {
            return;
        }

        if (progress) {
            this._spinTimeout = setTimeout(() => {
                if (!this._unmounted) {
                    this.setState({
                        spinVisible: true,
                    });
                }
            }, spinDelay);
        } else {
            clearTimeout(this._spinTimeout);

            this.setState({
                spinVisible: false,
            });
        }
    }

    render() {
        let { progress, cls, ...otherSpinProps } = this.props;
        let { spinVisible } = this.state;

        return (
            <div className={b({ progress }).mix(cls)}>
                <Spin
                    {...otherSpinProps}
                    progress={spinVisible}
                />
            </div>
        );
    }
}
