import React from 'react';
import { block } from 'bem-cn';
import ServicePage from 'components2/ServicePage';
import ServiceHeader from 'components2/ServiceHeader';
import ServiceDetails from 'components/ServiceDetails';
import ServicePlan from 'components2/ServicePlan';
import SubscriptionServiceTabs from 'components2/SubscriptionServiceTabs';
import isPartnerOrganization from 'lib2/isPartnerOrganization';

import './index.css';

const b = block('subscription-service-page');

export default ({ serviceSlug, actions, badge, tabs = [], subscriberSearchType, cls }) => (
    <ServicePage
        cls={b.mix(cls)}
        serviceSlug={serviceSlug}
    >
        <ServiceHeader
            serviceSlug={serviceSlug}
            actions={actions}
            badge={badge}
        />
        <ServiceDetails>
            {!isPartnerOrganization() &&
            <ServiceDetails.Item>
                <ServicePlan serviceSlug={serviceSlug} />
            </ServiceDetails.Item>}
        </ServiceDetails>
        <SubscriptionServiceTabs
            serviceSlug={serviceSlug}
            tabs={tabs}
            subscriberSearchType={subscriberSearchType}
        />
    </ServicePage>
);
