import React from 'react';
import { Icon } from 'lego-on-react';
import block from 'bem-cn';
import NavLink from 'components2/NavLink';
import ExternalIcon from 'components/Icon/External';

import './index.css';

const b = block('tab-link');

const TabLink = ({ children, cls, ...props }) => (
    <NavLink
        theme="normal"
        {...props}
        cls={b({}).mix(cls)}
    >
        {children}
    </NavLink>
);

TabLink.CounterBadge = ({ children }) =>
    <span className={b('counter-badge')}>{children}</span>;

TabLink.ExternalLinkBadge = () =>
    <Icon cls={b('external-link-badge')} glyph="yes"><ExternalIcon /></Icon>;

TabLink.Group = ({ children, cls }) =>
    <div className={b('group').mix(cls)}>{children}</div>;

TabLink.Pane = ({ children, cls }) =>
    <div className={b('pane').mix(cls)}>{children}</div>;

export default TabLink;
