import React from 'react';
import { block } from 'bem-cn';

const b = block('table');

const Table = ({ children, cls, type }) => (
    <table className={b({ type }).mix(cls)}>
        {children}
    </table>
);

Table.Thead = ({ children, cls }) => (
    <thead className={b('head').mix(cls)}>
        {children}
    </thead>
);

Table.Tbody = ({ children, cls }) => (
    <tbody className={b('body').mix(cls)}>
        {children}
    </tbody>
);

Table.Tr = ({ children, cls, ...otherProps }) => (
    <tr
        className={b('row').mix(cls)}
        {...otherProps}
    >
        {children}
    </tr>
);

Table.Td = ({ children, cls, role, ...otherProps }) => (
    <td
        className={b('cell', { role }).mix(cls)}
        {...otherProps}
    >
        {children}
    </td>
);

export default Table;
