import React from 'react';

export default class TrustPaymentForm extends React.PureComponent {
    constructor(props) {
        super(props);

        this._onWindowMessage = this._onWindowMessage.bind(this);
    }

    componentDidMount() {
        window.addEventListener('message', this._onWindowMessage);
    }

    componentWillUnmount() {
        window.removeEventListener('message', this._onWindowMessage);
    }

    _onWindowMessage({ data }) {
        if (!data.source || data.source !== 'YandexTrustPaymentForm') {
            return;
        }

        this._handleMessage(data);
    }

    _onSuccess(message) {
        this.props.onSuccess(message);
    }

    _onFailure(message) {
        this.props.onFailure(message);
    }

    _handleMessage({ type, data = {} }) {
        switch (type) {
            case 'payment-status':
                if (data.value === 'success') {
                    this._onSuccess('payment_success');
                }

                if (data.value === 'not_enough_funds') {
                    this._onFailure('not_enough_funds');
                }

                break;

            // Не обрабатываю, чтобы пользователь видел сообщение внутри айфрейма
            case 'payment-check-failure':
            case 'payment-update-failure':
                break;

            case 'payment-fail': // Это событие приходит после нажатия на OK при ошибке в айфрейме
                this._onFailure();
                break;

            case 'payment-complete': // Это событие приходит после нажатия на OK при успехе
                this._onSuccess();
                break;

            // Не обрабатываю это событие, чтобы пользователь видел сообщение внутри айфрейма
            case '3ds-status':
                break;

            case 'payment-timeout':
                this._onFailure('payment_timeout');
                break;

            default:
                break;
        }
    }

    render() {
        const { paymentUrl } = this.props;

        return (
            <iframe
                frameBorder="0"
                marginHeight="0"
                marginWidth="0"
                height="550"
                width="100%"
                src={paymentUrl}
            />
        );
    }
}
