import _ from 'lodash';
import keyMirror from 'keymirror';

const ActionTypes = keyMirror({

    RECEIVE_MIXED_DATA: null,
    RECEIVE_CONFIG_DATA: null,
    RECEIVE_REQUEST_DATA: null,
    RECEIVE_APPLICATION_DATA: null,
    RECEIVE_PROGRESS_DATA: null,

    RECEIVE_USER: null,
    RECEIVE_DEPARTMENT: null,
    RECEIVE_GROUP: null,
    RECEIVE_ORGANIZATION: null,
    RECEIVE_ORGANIZATION_SETTINGS: null,
    RECEIVE_SESSION: null,
    RECEIVE_DNS_RECORD: null,

    DISCARD_USER: null,
    DISCARD_DEPARTMENT: null,
    DISCARD_GROUP: null,
    DISCARD_ORGANIZATION: null,
    DISCARD_SESSION: null,
    DISCARD_DNS_RECORD: null,

    BEFORE_CHANGE_HISTORY: null,
    CHANGE_HISTORY: null,
    TRANSITION_COMPLETED: null,

    OPEN_MODAL_DIALOG: null,
    CLOSE_MODAL_DIALOG: null,
    CLEAR_MODAL_DIALOG: null,

    EDIT_USER: null,
    USER_EDITED: null,
    UPDATE_USER: null,

    EDIT_DEPARTMENT: null,
    DEPARTMENT_EDITED: null,

    EDIT_GROUP: null,
    GROUP_EDITED: null,

    EDIT_GROUP_MEMBERS: null,
    SELECT_GROUP_MEMBERS: null,
    GROUP_MEMBERS_EDITED: null,

    EDIT_ORGANIZATION_ADMINS: null,
    SELECT_ORGANIZATION_ADMINS: null,
    ORGANIZATION_ADMINS_EDITED: null,

    EDIT_ORGANIZATION_PROFILE: null,
    ORGANIZATION_PROFILE_EDITED: null,

    TYPE_NEW_DOMAIN: null,

    SUGGEST_LIST_OPEN: null,
    SUGGEST_LIST_CLOSED: null,

    NOTIFY: null,
    REMOVE_NOTIFICATION: null,
    SEND_BACKGROUND_NOTIFICATION: null,
    CANCEL_BACKGROUND_NOTIFICATION: null,

    SCROLL_LIST: null,
    CLICK_LIST: null,

    START_PROCESS: null,
    END_PROCESS: null,

    START_SETTINGS_PROCESS: null,
    END_SETTINGS_PROCESS: null,

    ADD_STATUS_BAR: null,
    CLEAR_STATUS_BAR: null,

    RECEIVE_INVITE_LINK: null,
    DISCARD_INVITE_LINK: null,

    RECEIVE_CAPTCHA: null,

    SERVICE_IS_BUSY: null,
});

const Permissions = {

    ADD_USERS: 'add_users',
    EDIT_USER: 'edit_user',
    EDIT_USER_INFO: 'edit_user_info',
    EDIT_USER_CONTACTS: 'edit_user_contacts',
    EDIT_USER_BIRTHDAY: 'edit_user_birthday',
    CHANGE_USER_PASSWORD: 'change_user_password',
    BLOCK_USER: 'block_user',
    MAKE_ADMIN: 'make_admin',
    DISMISS_USER: 'dismiss_user',
    INVITE_USERS: 'invite_users',
    CHANGE_AVATAR: 'change_avatar',
    CHANGE_ALIAS: 'change_alias',

    ADD_DEPARTMENTS: 'add_departments',
    EDIT_DEPARTMENT: 'edit_department',
    REMOVE_DEPARTMENTS: 'remove_departments',

    ADD_GROUPS: 'add_groups',
    EDIT_GROUP: 'edit_group',

    EDIT_ORGANIZATION: 'edit_organization',
    ROLLBACK_ORGANIZATION: 'rollback_organization',
    DELETE_ORGANIZATION: 'delete_organization',
    LEAVE_ORGANIZATION: 'leave_organization',

    PAY: 'can_pay',
    CHANGE_SUBSCRIPTION_PLAN: 'change_subscription_plan',
    MANAGE_LICENSES: 'manage_licences',
    CHANGE_LOGO: 'change_logo',
    CHANGE_OWNER: 'change_owner',
    CHANGE_ROLE: 'change_role',

    EDIT_DNS: 'edit_dns',

    ADD_DOMAINS: 'add_domains',
    CHANGE_MASTER_DOMAIN: 'change_master_domain',
    REMOVE_DOMAIN: 'remove_domain',

    MANAGE_TRACKER: 'manage_tracker',
    MANAGE_MAIL: 'manage_mail',

    ACTIVATE_PROMOCODE: 'activate_promocode',

    MANAGE_SERVICES: 'manage_services',

    UPDATE_SERVICE_DATA: 'update_service_data',
};

const ApiStatuses = keyMirror({
    UNAUTHORIZED: null,
    UNSAFE: null,
    OK: null,
});

const Groups = {
    ADMIN_GROUP_ID: '2',
};

const FeatureNames = {
    DOMAIN_AUTO_HANDOVER: 'domain-auto-handover',
    CAN_WORK_WITHOUT_OWNED_DOMAINS: 'can-work-without-owned-domains',
};

_.set(window.ya, 'connect.constants', { Permissions });

export { ActionTypes, Permissions, ApiStatuses, Groups, FeatureNames };
