export const defaultSource = 'unknown';

export const defaultReason = 'unknown';

export const reasonSettings = {
    unknown: {
        changeUser: true,
    },
    'external-user': {
        changeUser: true,
    },
    'external-admin': {
        changeUser: true,
    },
    deactivated: {
        admin: true,
        changeUser: true,
    },
    unlicensed: {
        admin: true,
        changeUser: true,
    },
};

export const servicesSettings = {
    unknown: {
        reasons: [
            'external-user',
            'external-admin',
            'deactivated',
            'unlicensed',
        ],
    },
    connect: {
        reasons: [
            'deactivated',
            'external-user',
            'blocked-org',
        ],
    },
    tracker: {
        reasons: [
            'external-user',
            'deactivated',
            'unlicensed',
        ],
    },
    wiki: {
        reasons: [
            'external-user',
            'deactivated',
            'unlicensed',
        ],
    },
    mail: {
        reasons: [
            'deactivated',
        ],
    },
    yamb: {
        reasons: [
            'external-user',
            'external-admin',
            'deactivated',
        ],
    },
    disk: {
        reasons: [
            'deactivated',
        ],
    },
    calendar: {
        reasons: [
            'external-user',
            'deactivated',
        ],
    },
    staff: {
        reasons: [
            'external-user',
            'external-admin',
            'deactivated',
        ],
    },
    forms: {
        reasons: [
            'external-user',
            'external-admin',
            'deactivated',
            'unlicensed',
        ],
    },
    'pdd-adapter': {
        reasons: [
            'forbidden_uid',
            'reg_check_failed',
        ],
    },
};
