/**
 * Страница для неворкспейсных пользователей
 */

import React from 'react';
import ReactDOM from 'react-dom';
import Forbidden from 'client/components/Forbidden';
import layout from 'lib/layout';
import Url from 'lib/Url';

import 'actions/Settings';
import { reasonSettings } from 'constants/Forbidden';

import 'lib/number.is-nan.js';

function getForbiddenPageProps() {
    const source = Url.getQueryParam('source');
    const reason = Url.getQueryParam('reason');

    return {
        source,
        reason,
        settings: reasonSettings[reason],
    };
}

layout.initialize().then(callback => {
    ReactDOM.render(
        <Forbidden {...getForbiddenPageProps()} />,
        document.getElementById('app'),
        callback
    );
});
