import _ from 'lodash';
import PropTypes from 'prop-types';

import './index.styl';

const Button = props => {
    const { mods, view, width, busy, addonRight, cls } = props;
    const buttonProps = _.omit(props, ['mods', 'view', 'text', 'width', 'busy', 'addonRight', 'cls']);

    let classNames = [
        Button._name,
        busy ? `${Button._name}_busy` : null,
        width === 'available' ? `${Button._name}_full-width` : null,
        view ? `${Button._name}_${view}` : null,
        cls,
    ];

    if (mods.length) {
        classNames = classNames.concat(mods.map(mod => `${Button._name}_${mod}`));
    }

    if (!buttonProps.type) {
        buttonProps.type = 'button';
    }

    return (
        <button className={classNames.filter(Boolean).join(' ')} {...buttonProps}>
            <span className={`${Button._name}__content`}>
                {props.children || props.text}
            </span>
            {addonRight}
        </button>
    );
};

// @if NODE_ENV='development'
Button.propTypes = {
    mods: PropTypes.array,
    type: PropTypes.string,
    onClick: PropTypes.func,
    disabled: PropTypes.bool,
};
// @endif

Button.defaultProps = {
    mods: [],
    disabled: false,
};

Button._name = 'lego-button';

export default Button;
