import _ from 'lodash';
import Link from 'ui/Link';

import 'lego-ui/Button/index.styl';
import './index.styl';

const LINK_PROPS = [
    'to', 'target', 'metrika',
];

const ButtonLink = props => {
    const className = [
        ButtonLink._name,
        props.width === 'available' ? `${ButtonLink._name}_full-width` : null,
        props.view ? `${ButtonLink._name}_${props.view}` : null,
    ].filter(Boolean).join(' ');

    return (
        <Link
            className={className}
            {..._.pick(props, LINK_PROPS)}
        >
            <span className="lego-button__content">
                {props.text}
            </span>
        </Link>
    );
};

ButtonLink._name = 'lego-button';

export default ButtonLink;
