import _ from 'lodash';
import PropTypes from 'prop-types';

import './index.styl';

const Checkbox = props => {
    const checkboxProps = _.omit(props, ['text', 'children', 'busy']);
    const containerClassName = [
        `${Checkbox._name}__container`,
        props.disabled ? `${Checkbox._name}__container_disabled` : null,
        props.busy ? `${Checkbox._name}__container_busy` : null,
    ].filter(Boolean).join(' ');

    return (
        <label className={containerClassName}>
            <input type="checkbox" className={Checkbox._name} {...checkboxProps} />
            <span className={`${Checkbox._name}__placeholder`} />
            <span className={`${Checkbox._name}__content`}>
                {props.children || props.text}
            </span>
        </label>
    );
};

Checkbox._name = 'lego-checkbox';

// @if NODE_ENV='development'
Checkbox.propTypes = {
    name: PropTypes.string,
    defaultChecked: PropTypes.bool,
};
// @endif

export default Checkbox;
