import React from 'react';
import Link from 'ui/Link';

import './index.styl';

const Tabs = React.createClass({

    _name: 'lego-tabs',

    getInitialState() {
        let { selectedTabId } = this.props;

        if (!selectedTabId && this.props.children) {
            this.props.children.forEach(item => {
                if (item && item.props.selected) {
                    selectedTabId = item.props.id;
                }
            });

            if (!selectedTabId) {
                selectedTabId = this._getDefaultSelectedTabId();
            }
        }

        return { selectedTabId };
    },

    componentWillReceiveProps(nextProps) {
        const { selectedTabId } = nextProps;

        if (selectedTabId !== this.state.selectedTabId) {
            this.setState({ selectedTabId });
        }
    },

    _getDefaultSelectedTabId() {
        if (this.props.children) {
            // ищем id первого не равного null вложенного элемента
            for (let i = 0; i < this.props.children.length; i++) {
                if (this.props.children[i]) {
                    return this.props.children[i].props.id;
                }
            }
        }
    },

    _handleTabClick(tabId) {
        this.setState({ selectedTabId: tabId });

        const { onChange } = this.props;

        if (onChange) {
            onChange(tabId);
        }
    },

    render() {
        const { selectedTabId } = this.state;
        let { children } = this.props;
        const component = { titles: [], tabs: [] };

        if (!Array.isArray(children)) {
            children = [children];
        }

        children.forEach((item, index) => {
            if (!item) {
                return;
            }

            const className = {};

            className.title = [
                'lego-tab__title',
                item.props.id === selectedTabId ? 'lego-tab__title_selected' : null,
                item.props.url ? 'lego-tab__title_link' : null,
            ].filter(Boolean).join(' ');

            className.tab = [
                'lego-tab',
                item.props.id === selectedTabId ? 'lego-tab_selected' : null,
            ].filter(Boolean).join(' ');

            if (item.props.url) {
                component.titles.push(
                    <Link
                        to={item.props.url}
                        className={className.title}
                        target={item.props.target}
                        key={index}
                    >
                        {item.props.title}
                    </Link>
                );
            } else {
                component.titles.push(
                    <Link
                        className={className.title}
                        key={index}
                        onClick={this._handleTabClick.bind(this, item.props.id)}
                    >
                        {item.props.title}
                    </Link>
                );
            }

            if (!item.props.forceRemount || item.props.id === selectedTabId) {
                component.tabs.push(
                    <div className={className.tab} key={index}>
                        {item.props.children}
                    </div>
                );
            }
        });

        return (
            <div className={`${this._name}__container`}>
                <div className={`${this._name}__header`}>
                    {component.titles}
                </div>
                <div className={`${this._name}__body`}>
                    {component.tabs}
                </div>
            </div>
        );
    },

});

Tabs.Item = () => null;

export default Tabs;
