import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';

import './index.styl';

const Textarea = React.createClass({

    _name: 'lego-textarea',

    getInitialState() {
        return {};
    },

    _handleFocus(event) {
        this.setState({ focused: true });

        if (this.props.onFocus) {
            this.props.onFocus(event);
        }
    },

    _handleBlur(event) {
        this.setState({ focused: false });

        if (this.props.onBlur) {
            this.props.onBlur(event);
        }
    },

    render() {
        const { width, size, val, disabled } = this.props;
        const elementProps = _.omit(this.props, ['val', 'width', 'size']);

        const className = classSet({
            [this._name]: true,
            [`${this._name}_size_${size}`]: Boolean(size),
            [`${this._name}_width_${width}`]: Boolean(width),
            [`${this._name}_disabled`]: disabled,
            [`${this._name}_focused`]: this.state.focused,
        });

        return (
            <textarea
                {...elementProps}
                className={className}
                onFocus={this._handleFocus}
                onBlur={this._handleBlur}
                defaultValue={val}
                aria-live="off"
            />
        );
    },

});

// @if NODE_ENV='development'
Textarea.propTypes = {
    width: PropTypes.string,
    size: PropTypes.string,
    val: PropTypes.string,
    disabled: PropTypes.bool,
};
// @endif

Textarea.defaultProps = {
    size: 'm',
};

export default Textarea;
