import _ from 'lodash';
import PropTypes from 'prop-types';

import './index.styl';

const Toggle = props => {
    const checkboxProps = _.omit(props, ['text', 'children', 'busy']);
    let content;

    const containerClassName = [
        `${Toggle._name}__container`,
        props.disabled ? `${Toggle._name}__container_disabled` : null,
        props.busy ? `${Toggle._name}__container_busy` : null,
    ].filter(Boolean).join(' ');

    if (props.children || props.text) {
        content = (
            <span className={`${Toggle._name}__content`}>
                {props.children || props.text}
            </span>
        );
    }

    return (
        <label className={containerClassName}>
            <span className={Toggle._name}>
                <input
                    type="checkbox"
                    {...checkboxProps}
                    className={`${Toggle._name}__checkbox`}
                />
                <span className={`${Toggle._name}__jumper`} />
            </span>
            {content}
        </label>
    );
};

Toggle._name = 'lego-toggle';

// @if NODE_ENV='development'
Toggle.propTypes = {
    name: PropTypes.string,
    disabled: PropTypes.bool,
    defaultChecked: PropTypes.bool,
};
// @endif

export default Toggle;
