import _ from 'lodash';
import template from 'lib/template';

const ContentMap = {
    A: '${address}',
    AAAA: '${address}',
    SRV: '${ttl} IN SRV ${priority} ${weight} ${port} ${target}',
    MX: '${exchange}',
    CNAME: '${target}',
    NS: '${target}',
};

export function getContent(record) {
    const { type, rdata, ttl } = record;

    if (type === 'TXT') {
        return rdata.strings && rdata.strings.join('');
    }

    if (ContentMap[type]) {
        return template.build(ContentMap[type], _.assign({ ttl }, rdata));
    }

    return record.content;
}

const DefaultPriorityMap = {
    SRV: 10,
    MX: 10,
};

export function getPriority(record) {
    const { rdata: { priority, preference }, type } = record;

    if (type === 'MX' && preference !== undefined) {
        return preference;
    }

    return priority === undefined ? DefaultPriorityMap[type] : priority;
}
