import _ from 'lodash';
import RSVP from 'rsvp';
import log from 'services/log';

function enableErrorLogging() {
    window.onerror = (message, source, line, col) => {
        log.error(message, { source, line, col, tag: 'js-exception' });
    };

    RSVP.on('error', (data, label) => {
        const msg = typeof data === 'string' ? data : _.get(data, 'message');

        if (msg) {
            log.error(`Error: ${msg}`, { label, tag: 'js-rsvp-error' });
        } else {
            log.error('Error: unknown', { keys: Object.keys(data), label, tag: 'js-rsvp-error' });
        }
    });
}

export default enableErrorLogging;
