import permissionsApi from 'api/permissions';

/**
 * Навешиваем обработчик на события пока/скрытия страницы
 * Если страницу стала видимой, дергаем ручку пинг.
 * В модуле requestApi обработываем от ручки.
 * В ответе ручки может прилететь 401 ошибка, тогда редиректим на пасспорт
 * или заголовок x-uid отличный от того что в конфиге, тогда кидаем на корневую страницу.
 */
function enableSessionCheck() {
    let hiddenProperty;
    let visibilityChangeEvent;

    if (document.hidden !== undefined) {
        hiddenProperty = 'hidden';
        visibilityChangeEvent = 'visibilitychange';
    } else if (document.mozHidden !== undefined) {
        hiddenProperty = 'mozHidden';
        visibilityChangeEvent = 'mozvisibilitychange';
    } else if (document.msHidden !== undefined) {
        hiddenProperty = 'msHidden';
        visibilityChangeEvent = 'msvisibilitychange';
    } else if (document.webkitHidden !== undefined) {
        hiddenProperty = 'webkitHidden';
        visibilityChangeEvent = 'webkitvisibilitychange';
    }

    function handleVisibilityChange() {
        if (!document[hiddenProperty]) {
            permissionsApi.checkAuth();
        }
    }

    if (visibilityChangeEvent && hiddenProperty) {
        document.addEventListener(visibilityChangeEvent, handleVisibilityChange, false);
    }
}

export default enableSessionCheck;
