import template from './template';
import common from './i18n.common';

const DatePattern = {
    default: '${date}\u00a0${month} ${year}\u00a0года',
    short: '${date}\u00a0${month}',
};

const PLURALIZATION_PATTERN = '${number}\u00a0${objects}';

const NumberFormat = {
    digitGroup: { size: 3, delimiter: '\u00a0' },
    fraction: { delimiter: ',' },
};

const CurrencyPatterns = {
    RUB: '${amount}\u00a0\u20bd',
    USD: '$\u2009${amount}',
};

const Months = [
    'января', 'февраля', 'марта', 'апреля', 'мая', 'июня',
    'июля', 'августа', 'сентября', 'октября', 'ноября', 'декабря',
];

// forms: [ one, few, many ]
function pluralize(number, forms, pattern) {
    const formattedNumber = formatNumber(number);
    const unsignedNumber = Math.abs(number);

    if (!(forms instanceof Array)) {
        return template.build(pattern || PLURALIZATION_PATTERN, {
            number: formattedNumber, objects: forms,
        });
    }

    let index = 2;

    if (unsignedNumber % 10 === 1 && unsignedNumber % 100 !== 11) {
        index = 0;
    } else if (unsignedNumber % 10 >= 2 && unsignedNumber % 10 <= 4 &&
        (unsignedNumber % 100 < 10 || unsignedNumber % 100 >= 20)) {
        index = 1;
    }

    return template.build(pattern || PLURALIZATION_PATTERN, {
        number: formattedNumber, objects: forms[index],
    });
}

// 12345.6789 > '12 345,6789'
function formatNumber(value, type) {
    return common.formatNumber(value, NumberFormat, type);
}

function formatCurrency(amount, currency) {
    if (!CurrencyPatterns[currency]) {
        return `${formatNumber(amount, 'currency')}\u00a0${currency}`;
    }

    return template.build(CurrencyPatterns[currency], {
        amount: formatNumber(amount, 'currency'),
    });
}

const ru = {
    pluralize,
    formatNumber,
    formatCurrency,
    DatePattern,
    Months,
};

export default ru;
