import template from './template';
import common from './i18n.common';

const DatePattern = {
    default: '${date}\u00a0${month} ${year}\u00a0года',
    short: '${date}\u00a0${month}',
};

const PLURALIZATION_PATTERN = '${number}\u00a0${objects}';

const NumberFormat = {
    digitGroup: { size: 3, delimiter: ',' },
    fraction: { delimiter: '.' },
};

const CurrencyPatterns = {
    RUB: '${amount}\u00a0\u20bd',
    USD: '$\u2009${amount}',
};

const Months = [
    'Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz',
    'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık',
];

// forms: [ one, many ]
export function pluralize(number, forms, pattern) {
    return template.build(pattern || PLURALIZATION_PATTERN, {
        number: formatNumber(number),
        objects: forms instanceof Array ? forms[Math.abs(number) === 1 ? 0 : 1] : forms,
    });
}

// 12345.6789 > '12,345.6789'
export function formatNumber(value, type) {
    return common.formatNumber(value, NumberFormat, type);
}

function formatCurrency(amount, currency) {
    if (!CurrencyPatterns[currency]) {
        return `${currency}\u00a0${formatNumber(amount, 'currency')}`;
    }

    return template.build(CurrencyPatterns[currency], {
        amount: formatNumber(amount, 'currency'),
    });
}

const tr = {
    pluralize,
    formatNumber,
    formatCurrency,
    DatePattern,
    Months,
};

export default tr;
