import _ from 'lodash';
import { getCookie } from '@connect/cookies-lite';
import ConfigStore from 'stores/Config';
import AuthStore from 'stores/Auth';
import Url from 'lib/Url';

let YaMetrika;

export default {
    init,
    send,
    reachGoal,
    getUserType,
};

function init() {
    let metrikaId = ConfigStore.get('metrika.default');
    const generalMetrikaId = ConfigStore.get('metrika.general');

    let userParams = {
        UserID: _.get(window.ya, 'connect.initial.state.session'),
        OrgID: _.get(window.ya, 'connect.initial.state.organization'),
        YandexUID: getCookie('yandexuid'),
    };

    // На проде для страницы дорегистрации должен быть отдельный счетчик метрики
    if (Url.isSetupPath()) {
        metrikaId = ConfigStore.get('metrika.setup') || metrikaId;
    }

    try {
        YaMetrika = new Ya.Metrika({
            id: metrikaId,
            clickmap: true,
            trackHash: true,
            trackLinks: true,
            accurateTrackBounce: true,
            userParams,
        });

        if (generalMetrikaId && generalMetrikaId !== metrikaId) {
            new Ya.Metrika({ // eslint-disable-line no-new
                id: generalMetrikaId,
                clickmap: true,
                trackHash: true,
                trackLinks: true,
                accurateTrackBounce: true,
                userParams,
            });
        }
    } catch (e) {
        /* empty */
    }

    window.ya.connect.YaMetrika = YaMetrika;
    window.ya.connect.YaMetrikaUserParams = userParams;
}

/**
 * Отправляет метрику
 * Входные параметры могу предтставлять собой:
 * список агрументов - send("Promo", "first", "second", "click")
 * массив или несколько массивов send(["Promo", "first"], ["second", "click"])
 * В метрику данные будут передаются в виде объекта { "Promo": { "first": { "second": "click" }}}
 */
function send() {
    let args = Array.prototype.slice.call(arguments);

    // сглаживаем параметры
    // [["Promo", "Some"], "click"] -> ["Promo", "Some", "click"]
    args = _.flatten(args);

    // забираем последний параметр
    let params = args.pop();

    // если остались ещё параметры - начинаем оборачивания
    while (args.length) {
        params = _wrap(params, args.pop());
    }

    try {
        YaMetrika.params(params);
    } catch (e) {
        // empty
    }
}

// https://yandex.ru/support/metrika/general/goal-js-event.html#js-event
// обычно достаточно (goalId:string)
function reachGoal() {
    try {
        YaMetrika.reachGoal.apply(YaMetrika, arguments);
    } catch (e) {
        // empty
    }
}

function getUserType() {
    return AuthStore.isAdmin() || !AuthStore.isInternal() ? 'Админ' : 'Пользователь';
}

/**
 * Создает объект с свойством name, значением которого будет params
 * Например: _wrap({a: 1}, 'b') создаст объект { b: {a: 1} }
 * @param {Object|String} params
 * @param {String} name
 * @returns {Object}
 * @private
 */
function _wrap(params, name) {
    const result = {};

    result[name] = params;

    return result;
}
