import ReactDOM from 'react-dom';
import withinViewport from './withinViewport';

function scrollTo(scrollPane, targetElement) {
    if (!scrollPane || !targetElement) {
        return;
    }

    if (!targetElement.nodeType) {
        targetElement = ReactDOM.findDOMNode(targetElement);
    }

    if (!targetElement) {
        return;
    }

    if (withinViewport(targetElement, scrollPane.getScrollState()) === false) {
        setTimeout(() => scrollPane.scrollYTo(targetElement.offsetTop), 0);
    }
}

export default scrollTo;
