import log from 'services/log';
import AuthStore from 'stores/Auth';

const timers = {};

export default {
    start,
    stop,
    clear,
};

function start(timerName) {
    timers[timerName] = Date.now();
}

function clear(timerName) {
    delete timers[timerName];
}

function stop(timerName) {
    if (!timers[timerName]) {
        return;
    }

    const data = {
        message: 'Portal_client_timer',
        totalTime: Date.now() - timers[timerName],
        uid: AuthStore.getUserId(),
        url: window.location.pathname + window.location.search + window.location.hash,
        timerName,
    };

    clear(timerName);

    log.info(timerName, data);

    log.sendServiceLog(data);
}
