/**
 * Конвертация произвольных данных в блоб
 * @method  toBlob
 * @param   {String|Object}  data
 * @returns {Blob}
 */
function toBlob(data) {
    if (data instanceof Blob) {
        return data;
    }

    // вычисляем тип данных, если это base64-строка
    // `data:<type>;<body>`
    const type = typeof data === 'string' ? (data.match(/^data:([^;]+);/) || [])[1] : null;

    if (!type) {
        return null;
    }

    // конвертируем base64-строку в бинарную строку
    const byteString = atob(data.split('base64,')[1]);
    const byteArray = new Uint8Array(byteString.length);

    // конвертируем бинарную строку в массив байтов
    for (let i = 0; i < byteString.length; i++) {
        byteArray[i] = byteString.charCodeAt(i);
    }

    return new Blob([byteArray], { type });
}

export default toBlob;
