import toBlob from 'lib/toBlob';

function toFormData(data = {}, options = {}) {
    const formData = new FormData();

    Object.keys(data).forEach(key => {
        if (data[key] !== undefined) {
            if (options.files && options.files.indexOf(key) !== -1) {
                formData.append(key, toBlob(data[key]));
            } else if (typeof data[key] === 'object') {
                formData.append(key, JSON.stringify(data[key]));
            } else {
                formData.append(key, data[key]);
            }
        }
    });

    return formData;
}

export default toFormData;
