import _ from 'lodash';

/**
 * Приводит ключи объекта в соответствие с именованием в нативном стиле JS
 * @param   {Object} data
 * @returns {Object}
 */
function toJS(data) {
    const mappedData = {};

    _.each(data, (value, key) => {
        mappedData[_.camelCase(key)] = value;
    });

    return mappedData;
}

export default toJS;
