import _ from 'lodash';
import ReactDOM from 'react-dom';

function getDefaultViewport() {
    return {
        topPosition: 0,
        leftPosition: 0,
        containerHeight: window.innerHeight || document.documentElement.clientHeight,
        containerWidth: window.innerWidth || document.documentElement.clientWidth,

        // отступы, расширяющие реальную область видимости
        topMargin: 0,
        bottomMargin: 0,
        leftMargin: 0,
        rightMargin: 0,
    };
}

/*
function withinScreenViewport(element) {
    if (!element) {
        return;
    }

    var bounds = element.getBoundingClientRect();

    return (
        bounds.top >= 0 &&
        bounds.left >= 0 &&
        bounds.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
        bounds.right <= (window.innerWidth || document.documentElement.clientWidth)
    );
}
*/

function withinViewport(element, viewport, margins) {
    if (!element) {
        return;
    }

    if (!element.nodeType) {
        element = ReactDOM.findDOMNode(element);
    }

    if (!element) {
        return;
    }

    viewport = _.extend(getDefaultViewport(), viewport, margins);

    return (
        (element.offsetTop + element.offsetHeight >=
            viewport.topPosition - viewport.topMargin) &&
        (element.offsetTop <=
            viewport.topPosition + viewport.containerHeight + viewport.bottomMargin) &&
        (element.offsetLeft + element.offsetWidth >=
            viewport.leftPosition - viewport.leftMargin) &&
        (element.offsetLeft <=
            viewport.leftPosition + viewport.containerWidth + viewport.rightMargin)
    );
}

export default withinViewport;
