import VisiblePolling from '@connect/polling/visible';
import fetchServices from 'lib2/fetchServices';
import { ServiceStore } from 'lib2/stores';
import toServiceStoreState from 'lib2/toServiceStoreState';

const ServiceStatusPolling = new VisiblePolling(() => {
    return fetchServices()
        .then(({ body }) => {
            ServiceStore.mergeState(toServiceStoreState(body));
        })
        .catch(() => { /* ignore */ });
}, counter => counter < 20 ? 10000 : 180000);

export default window.ya.connect.ServiceStatusPolling = ServiceStatusPolling;
