import directory from 'api2/directory';
import { BalanceStore } from './stores';
import isPartnerOrganization from './isPartnerOrganization';

export default () => {
    if (isPartnerOrganization()) {
        return Promise.resolve(true);
    }

    let prefetch = Promise.resolve();

    if (BalanceStore.get('has_contract') === undefined) {
        prefetch = directory.send('GET', '/v11/subscription/')
            .then(({ body }) => {
                BalanceStore.mergeState(body);
            });
    }

    return prefetch.then(() => BalanceStore.get('has_contract'));
};
