function copy(text) {
    if (document.queryCommandSupported && document.queryCommandSupported('copy')) {
        const buffer = document.createElement('textarea');

        buffer.textContent = text;
        document.body.appendChild(buffer);
        buffer.select();

        try {
            document.execCommand('copy');
        } catch (e) {
            return false;
        }

        document.body.removeChild(buffer);

        return true;
    } else if (window.clipboardData && window.clipboardData.setData) {
        // IE-specific
        window.clipboardData.setData('Text', text);

        return true;
    }

    return false;
}

const supported = Boolean(
    (document.queryCommandSupported && document.queryCommandSupported('copy')) ||
    (window.clipboardData && window.clipboardData.setData)
);

export default supported && copy;
