import directory from 'api2/directory';

export default function fetchDomainOwnership(domain) {
    if (!domain) {
        return Promise.resolve(domain);
    }

    return directory
        .send('GET', `/v11/domains/${encodeURIComponent(domain.name)}/ownership-info/`)
        .then(({ ok, body }) => {
            if (!ok || !body) {
                return domain;
            }

            return {
                ...domain,
                verification_status: body.status,
                preferred_host: body.preferred_host,
                methods: body.methods,
                last_check: body.last_check,
            };
        });
}
