import get from 'lodash/get';
import gendarme from 'api2/gendarme';

export default function fetchGendarmeData(domain) {
    return gendarme
        .send('GET', '/domain/status', {
            query: {
                name: domain.name,
            },
        })
        .then(({ ok, body }) => {
            domain.gendarme = true;

            if (ok && body && body.status === 'ok') {
                domain.mx = get(body, 'response.mx.match');
                domain.delegated = get(body, 'response.ns.match');
            }

            return domain;
        });
}
