import { OrgStore } from 'lib2/stores';
import getOrganization from 'lib2/getOrganization';
import directory from 'api2/directory';

export default function fetchOrgLogo() {
    let orgId = getOrganization().id;

    return directory
        .send('GET', `/v11/organizations/${orgId}/`, {
            query: {
                fields: 'logo',
            },
        })
        .then(({ ok, body }) => {
            if (ok) {
                OrgStore.set([orgId, 'logo'], body.logo);
            }
        });
}
