import buildString from '@connect/string-placeholders';

const ContentMap = {
    A: '${address}',
    AAAA: '${address}',
    SRV: '${ttl} IN SRV ${priority} ${weight} ${port} ${target}',
    MX: '${exchange}',
    CNAME: '${target}',
    NS: '${target}',
};

export default function getDnsRecordContent(record) {
    let { type, rdata = {}, ttl } = record;

    if (type === 'TXT') {
        return rdata.strings && rdata.strings.join('');
    }

    if (ContentMap[type]) {
        return buildString(ContentMap[type], { ttl, ...rdata });
    }

    return rdata.content;
}
