const DefaultPriorityMap = {
    SRV: 10,
    MX: 10,
};

export default function getDnsRecordPriority({ type, rdata = {} }) {
    let { preference, priority } = rdata;

    if (type === 'MX') {
        return preference === undefined ? DefaultPriorityMap.MX : preference;
    }

    return priority === undefined ? DefaultPriorityMap[type] : priority;
}
