import buildUrl from '@connect/url-placeholders';
import setFormUrlParams from 'lib2/setFormUrlParams';
import { ConfigStore } from './stores';
import getOrganization from './getOrganization';

export default (configKey, params) => {
    let org = getOrganization();
    let basicFormData;

    if (org) {
        basicFormData = {
            org_id: org.id,
            v: org.vip && org.vip.length ? 1 : 0,
        };
    }

    return setFormUrlParams(
        buildUrl(ConfigStore.get(configKey), params),
        basicFormData
    );
};
