import { ConfigStore } from './stores';

export const NameFormat = {
    // Иван Петров
    REGULAR: 'REGULAR',

    // Петров Иван Васильевич
    // NB: для сортировок - регистронезависимый SORTABLE
    ALPHABETICAL: 'ALPHABETICAL',

    // петров иван васильевич
    SORTABLE: 'SORTABLE',

    // Иван Васильевич
    SHORT: 'SHORT',

    // Иван Васильевич Петров
    FULL: 'FULL',
};

function join(components, locale) {
    return components
        .map(component => {
            if (!component || typeof component !== 'object') {
                return component || '';
            }

            return component[locale] || '';
        })
        .filter(Boolean)
        .join(' ');
}

function compound(...components) {
    return join(components, ConfigStore.get('app.locale')) || join(components, 'ru');
}

export default (object, nameFormat = NameFormat.REGULAR) => {
    if (!object) {
        return;
    }

    let { name } = object;

    if (!name || typeof name !== 'object') {
        return name;
    }

    let { first, middle, last } = name;

    switch (nameFormat) {
        case NameFormat.REGULAR:
            return compound(first, last);
        case NameFormat.ALPHABETICAL:
            return compound(last, first, middle);
        case NameFormat.SORTABLE:
            return (compound(last, first, middle) || '').toLowerCase();
        case NameFormat.SHORT:
            return compound(first, middle);
        case NameFormat.FULL:
            return compound(first, middle, last);
    }
};
