export default function getOrgChangeUrl(orgId, retpath) {
    let { origin } = window.location;
    let url = new URL('/portal/context', origin);

    url.searchParams.set('mode', 'portal');
    url.searchParams.set('sk', window.ya.connect.initial.sk);

    if (orgId) {
        url.searchParams.set('org_id', orgId);
    }

    if (retpath) {
        url.searchParams.set('retpath', new URL(retpath, origin).href);
    }

    return url.href;
}
