import getOrganization from 'lib2/getOrganization';
import directory from 'api2/directory';

export default function getOwnedDomains() {
    let org = getOrganization();
    let ownedDomains = org.domains && org.domains.owned;

    if (ownedDomains !== undefined) {
        return Promise.resolve(ownedDomains);
    }

    return directory
        .send('GET', `/v11/organizations/${org.id}/`, {
            query: {
                fields: 'domains',
            },
        })
        .then(({ ok, body: { domains } }) => {
            if (!ok || !domains) {
                return [];
            }

            return domains.owned;
        });
}
