/**
 * Возвращает путь от корня приложения
 * @method  getPath
 * @param   {...String}  parts  относительный путь или его компоненты
 * @returns {String}
 */
import { ConfigStore } from './stores';

export default (...parts) => {
    // ('a', 'b') => '{app_root}/a/b'
    const pathComponents = parts
        .map(part => part ? String(part).replace(/^\//, '') : '')
        .filter(Boolean);

    return ConfigStore.get('app.root') +
        pathComponents.join('/').replace('/#', '#');
};
