export default originId => {
    let sources = [];
    let { searchParams } = new URL(window.location.href);

    if (originId) {
        sources.push(`origin=${originId}`);
    }

    for (const [key, value] of searchParams) {
        if (key.startsWith('utm_') || key === 'source') {
            sources.push(`${key}=${value}`);
        }
    }

    return sources.join('|');
};
