import buildUrl from '@connect/url-placeholders';
import { ConfigStore, SessionStore } from './stores';

export default function getUserUrl(uid) {
    if (uid === undefined) {
        uid = SessionStore.get('context.uid');
    }

    // когда находимся в админке, ссылки тоже внутри админки
    if (/^\/portal\/admin(\/|$)/.test(window.location.pathname)) {
        return `/portal/admin/users/${uid}`;
    }

    return buildUrl(ConfigStore.get('ui.staff'), {
        nickname: SessionStore.get('user.nickname'),
        org_id: SessionStore.get('context.org_id'),
        uid,
    });
}
