import { PermissionStore } from 'lib2/stores';

export default (permission, object, ignoreGlobal) => {
    const objectPath = object && (object.path || [object.type, object.id]);

    const path = object ? ['local', ...objectPath] : ['global'];
    let permissions = PermissionStore.get(path);

    if (object && !permissions && !ignoreGlobal) {
        permissions = PermissionStore.get('global');
    }

    return Boolean(permissions && permissions.includes(permission));
};
