export default function isAllowedIframeOrigin(origin) {
    let { hostname } = new URL(origin);

    if (hostname === window.location.hostname) {
        return true;
    }

    let allowedIframeOriginHosts = window.ya.connect.config.frameAncestors;

    if (!Array.isArray(allowedIframeOriginHosts)) {
        return false;
    }

    return allowedIframeOriginHosts.some(item => {
        if (item === '*') {
            return true;
        }

        if (item.indexOf('*.') === 0) {
            let itemBase = item.substring(2); // без '*.'

            // true, если hostname заканчивается на itemBase
            return hostname.slice(-itemBase.length) === itemBase;
        }

        return item === hostname;
    });
}
