function handleHash(hash, callback) {
    if (window.location.hash === hash) {
        callback();

        if (window.history) {
            history.replaceState(null, '', window.location.pathname);
        } else {
            window.location.hash = '';
        }
    }
}

export default function onUrlHash(hash, callback) {
    let { pathname } = window.location;
    let _callback = () => window.location.pathname === pathname && handleHash(hash, callback);

    handleHash(hash, callback);

    window.addEventListener('hashchange', _callback);

    return {
        remove: () => {
            window.removeEventListener('hashchange', _callback);
        },
    };
}
