export default function openFile(data, mime, fileName = 'connect') {
    const blob = new Blob([data], { type: mime || 'application/octet-stream' });

    // IE doesn't allow using a blob object directly as link href
    if (window.navigator && window.navigator.msSaveOrOpenBlob) {
        window.navigator.msSaveOrOpenBlob(blob, fileName);

        return;
    }

    const blobURL = window.URL.createObjectURL(blob);
    const link = document.createElement('a');

    link.style.display = 'none';
    link.href = blobURL;
    link.download = fileName;

    document.body.appendChild(link);

    link.click();
    link.parentNode.removeChild(link);

    setTimeout(() => {
        // For Firefox it is necessary to delay revoking the ObjectURL
        window.URL.revokeObjectURL(blobURL);
    }, 100);
}
