import AppHistory from './AppHistory';

const isAbsolute = url => /^(https?:)?\/\//.test(url);

export default function openUrl(url, target) {
    if (url.indexOf('#') === 0) {
        url = window.location.pathname + url;
    }

    if (target !== '_self') {
        if (target) {
            return void (window.open(url, target).opener = null);
        }

        if (!isAbsolute(url)) {
            return AppHistory.push(url);
        }
    }

    window.location.href = url;
}
