/**
 * Добавляет к url query-параметры, передаваемые в формы, встроеннные в страницу
 *
 * @param {String} url
 * @param {Object} formData
 * @param {String?|Number?} formId
 * @returns {String}
 * @see https://st.yandex-team.ru/LOCDOC-732
 *
 * ('https://ya.ru/help', { x: 1 }) > 'https://ya.ru/help?form-x=1'
 * ('https://ya.ru/help', { x: 1 }, 321) > 'https://ya.ru/help?form321-x=1'
 */
export default (url, formData = {}, formId) => {
    let nextUrl = new URL(url, new URL(window.location.href).origin);
    let nextQuery = new URLSearchParams(nextUrl.search);

    Object.entries(formData).forEach(([key, value]) => {
        if (value !== null && value !== undefined) {
            nextQuery.set(`form${formId || ''}-${key}`, value);
        }
    });

    nextUrl.search = nextQuery.toString();

    return nextUrl.href;
};
